--ACCOUNT
begin
-- ak chceme vkladat, ziskavat alebo modifikovat udaje musime vediet nastavit client_id
dbms_rls.add_policy(object_schema => 'BANK_IS2',
                    object_name => 'ACCOUNT',
                    policy_name => 'account_sui_policy',
                    function_schema => 'BANK_IS2',
                    policy_function => 'client_id_policy',
                    statement_types => 'SELECT,INSERT,UPDATE',
                    policy_type => dbms_rls.SHARED_STATIC);

-- nepovolime odstranovanie zaznamov z tabulky account
dbms_rls.add_policy(object_schema => 'BANK_IS2',
                    object_name => 'ACCOUNT',
                    policy_name => 'account_d_policy',
                    function_schema => 'BANK_IS2',
                    policy_function => 'not_allowed_policy',
                    statement_types => 'DELETE',
                    policy_type => dbms_rls.SHARED_STATIC);

-- vkladat moze iba zamestnanec
dbms_rls.add_policy(object_schema => 'BANK_IS2',
                    object_name => 'ACCOUNT',
                    policy_name => 'account_i_policy',
                    function_schema => 'BANK_IS2',
                    policy_function => 'must_be_teller_policy',
                    statement_types => 'INSERT',
                    update_check => TRUE,
                    policy_type => dbms_rls.SHARED_STATIC);

-- vymenujeme stlpce ktore nemoze definovat v inserte
dbms_rls.add_policy(object_schema => 'BANK_IS2',
                    object_name => 'ACCOUNT',
                    policy_name => 'account_i_col_policy',
                    function_schema => 'BANK_IS2',
                    policy_function => 'not_allowed_policy',
                    statement_types => 'INSERT',
                    update_check => TRUE,
                    policy_type => dbms_rls.SHARED_STATIC,
                    sec_relevant_cols => 'BALANCE');
end;                    
/
-- zakaznik moze prezerat udaje a modifikovat phone_no
GRANT SELECT ON account TO client2;

-- zamestnancovi umoznime vidiet a upravovat udaje o zakaznikovom ucte a vytvorit novy zakaznicky ucet
GRANT SELECT ON account TO teller2;
GRANT UPDATE(day_limit,valid) ON account TO teller2;
GRANT INSERT ON account TO teller2;


begin
-- ACCOUNT TYPE  
-- vkladat moze iba admin
dbms_rls.add_policy(object_schema => 'BANK_IS2',
                    object_name => 'ACCOUNT_TYPE',
                    policy_name => 'account_type_ui_policy',
                    function_schema => 'BANK_IS2',
                    policy_function => 'must_be_admin_policy',
                    statement_types => 'INSERT,UPDATE',
                    policy_type => dbms_rls.SHARED_STATIC,
                    update_check => TRUE);                    

-- odstranovat nemoze nikto
dbms_rls.add_policy(object_schema => 'BANK_IS2',
                    object_name => 'ACCOUNT_TYPE',
                    policy_name => 'account_type_d_policy',
                    function_schema => 'BANK_IS2',
                    policy_function => 'not_allowed_policy',
                    statement_types => 'DELETE',
                    policy_type => dbms_rls.SHARED_STATIC);
end;
/
-- pravo na citanie dame kazdemu okrem terminalu
GRANT SELECT ON account_type to teller2;
GRANT SELECT ON account_type to client2;
GRANT SELECT ON account_type to is_admin2;
GRANT INSERT ON account_type to is_admin2;
-- admin nemoze menit ID
GRANT UPDATE(interest,fee,type_name,valid) ON account_type to is_admin2;


-- PREDEFINED_PAYMENT   - preddefinovana platba
begin
-- zakaznik ma plne prava, ostatny nemaju ziadne
dbms_rls.add_policy(object_schema => 'BANK_IS2',
                    object_name => 'PREDEFINED_PAYMENT',
                    policy_name => 'predefined_payment_suid_policy',
                    function_schema => 'BANK_IS2',
                    policy_function => 'must_be_client_policy',
                    statement_types => 'SELECT,INSERT,UPDATE,DELETE',
                    update_check => TRUE,
                    policy_type => dbms_rls.SHARED_STATIC);
end;
/                
GRANT SELECT ON predefined_payment TO client2;
GRANT DELETE ON predefined_payment TO client2;
GRANT INSERT ON predefined_payment TO client2;
GRANT UPDATE ON predefined_payment TO client2;

--TRANSACTION  
begin
dbms_rls.add_policy(object_schema => 'BANK_IS2',
                    object_name => 'TRANSACTION',
                    policy_name => 'transaction_s_policy',
                    function_schema => 'BANK_IS2',
                    policy_function => 'account_transactions_policy',
                    statement_types => 'SELECT',
                    policy_type => dbms_rls.SHARED_STATIC);

-- modifikacia ani odstranovanie zaznamov nebude mozne.
dbms_rls.add_policy(object_schema => 'BANK_IS2',
                    object_name => 'TRANSACTION',
                    policy_name => 'transaction_d_policy',
                    function_schema => 'BANK_IS2',
                    policy_function => 'not_allowed_policy',
                    statement_types => 'DELETE,UPDATE',
                    policy_type => dbms_rls.SHARED_STATIC);

-- prideluje politiku pre vkladanie do pohladu transaction
dbms_rls.add_policy(object_schema => 'BANK_IS2',
                    object_name => 'V_TRANSACTION',  -- pohlad
                    policy_name => 'transaction_i_policy',
                    function_schema => 'BANK_IS2',
                    policy_function => 'transaction_insert_policy',
                    statement_types => 'INSERT',
                    policy_type => dbms_rls.DYNAMIC,
                    update_check => TRUE); 

end;
/

-- pravp na citanie ma kazdy okrem terminalu
GRANT SELECT ON v_transaction TO client2;
GRANT SELECT ON v_transaction TO teller2;
GRANT INSERT ON v_transaction TO client2;
GRANT INSERT ON v_transaction TO teller2;
GRANT INSERT ON v_transaction TO terminal2;


-- GRID_CARD          --OK --TESTED
begin
-- musi vediet nastavit client_id
dbms_rls.add_policy(object_schema => 'BANK_IS2',
                    object_name => 'GRID_CARD',
                    policy_name => 'grid_card_sui_policy',
                    function_schema => 'BANK_IS2',
                    policy_function => 'client_id_policy',
                    statement_types => 'SELECT,INSERT,UPDATE',
                    policy_type => dbms_rls.SHARED_STATIC);

-- zakazeme odstranovanie zaznamov
dbms_rls.add_policy(object_schema => 'BANK_IS2',
                    object_name => 'GRID_CARD',
                    policy_name => 'grid_card_d_policy',
                    function_schema => 'BANK_IS2',
                    policy_function => 'not_allowed_policy',
                    statement_types => 'DELETE',
                    policy_type => dbms_rls.SHARED_STATIC);

-- vkladat a modifikovat moze iba zamestnanec
dbms_rls.add_policy(object_schema => 'BANK_IS2',
                    object_name => 'GRID_CARD',
                    policy_name => 'grid_card_ui_policy',
                    function_schema => 'BANK_IS2',
                    policy_function => 'must_be_teller_policy',
                    statement_types => 'INSERT,UPDATE',
                    update_check => TRUE,
                    policy_type => dbms_rls.SHARED_STATIC);

-- nedovolime vkladat new_card -> default 1
dbms_rls.add_policy(object_schema => 'BANK_IS2',
                    object_name => 'GRID_CARD',
                    policy_name => 'grid_card_i_col_policy',
                    function_schema => 'BANK_IS2',
                    policy_function => 'not_allowed_policy',
                    statement_types => 'INSERT',
                    update_check => TRUE,
                    sec_relevant_cols => 'NEW_CARD',
                    policy_type => dbms_rls.SHARED_STATIC);
end;
/

GRANT SELECT ON grid_card TO client2;
GRANT SELECT ON grid_card TO teller2;
GRANT INSERT ON grid_card TO teller2;
GRANT UPDATE(valid) ON grid_card TO teller2;

-- CLIENT      
-- musi vediet nastavit id 
begin
dbms_rls.add_policy(object_schema => 'BANK_IS2',
                    object_name => 'V_CLIENT',
                    policy_name => 'client_s_policy',
                    function_schema => 'BANK_IS2',
                    policy_function => 'client_id_policy',
                    statement_types => 'SELECT',
                    policy_type => dbms_rls.SHARED_STATIC); 
                    
-- Nikomu nedovolime vidiet heslo a sol
dbms_rls.add_policy(object_schema => 'BANK_IS2',
                    object_name => 'V_CLIENT',
                    policy_name => 'client_s_col_policy',
                    function_schema => 'BANK_IS2',
                    policy_function => 'not_allowed_policy',
                    statement_types => 'SELECT',
                    policy_type => dbms_rls.SHARED_STATIC,
                    sec_relevant_cols => 'PASSWORD,SALT',
                    sec_relevant_cols_opt => dbms_rls.ALL_ROWS );
                    
dbms_rls.add_policy(object_schema => 'BANK_IS2',
                    object_name => 'V_CLIENT',
                    policy_name => 'client_u_policy',
                    function_schema => 'BANK_IS2',
                    policy_function => 'client_id_policy',
                    statement_types => 'UPDATE',
                    policy_type => dbms_rls.SHARED_STATIC); 
                    
-- Nedovolime odstranit
dbms_rls.add_policy(object_schema => 'BANK_IS2',
                    object_name => 'CLIENT',
                    policy_name => 'client_d_policy',
                    function_schema => 'BANK_IS2',
                    policy_function => 'not_allowed_policy',
                    statement_types => 'DELETE',
                    policy_type => dbms_rls.SHARED_STATIC);                    

-- Vkladat zaznamy moze len zamestnanec
dbms_rls.add_policy(object_schema => 'BANK_IS2',
                    object_name => 'CLIENT',
                    policy_name => 'client_i_policy',
                    function_schema => 'BANK_IS2',
                    policy_function => 'must_be_teller_policy',
                    statement_types => 'INSERT',
                    policy_type => dbms_rls.SHARED_STATIC,
                    update_check => TRUE);                    
                    
-- tato politika neumoznuje zamestnancovi pre biznis zakaznikov vytvorit obycajneho zakaznika
-- a neumoznuje zamestnancovi pre obycajnych zakaznikov vytvorit biznis zakaznika
dbms_rls.add_policy(object_schema => 'BANK_IS2',
                    object_name => 'CLIENT',
                    policy_name => 'client_i2_policy',
                    function_schema => 'BANK_IS2',
                    policy_function => 'client_insert_policy',
                    statement_types => 'INSERT',
                    policy_type => dbms_rls.SHARED_STATIC,
                    update_check => TRUE);                    
end;
/

GRANT SELECT ON v_client TO client2;
GRANT SELECT ON v_client TO teller2;
GRANT UPDATE(phone_no) ON v_client TO client2;
GRANT UPDATE(phone_no,address,valid) ON v_client TO teller2;
GRANT INSERT ON v_client TO teller2;

-- CARD --OK
begin
dbms_rls.add_policy(object_schema => 'BANK_IS2',
                    object_name => 'V_CARD',
                    policy_name => 'card_s_policy',
                    function_schema => 'BANK_IS2',
                    policy_function => 'account_no_policy',
                    statement_types => 'SELECT',
                    policy_type => dbms_rls.SHARED_STATIC); 
                    
-- Nikomu nedovolime vidiet pin
dbms_rls.add_policy(object_schema => 'BANK_IS2',
                    object_name => 'V_CARD',
                    policy_name => 'card_s_col_policy',
                    function_schema => 'BANK_IS2',
                    policy_function => 'not_allowed_policy',
                    statement_types => 'SELECT',
                    policy_type => dbms_rls.SHARED_STATIC,
                    sec_relevant_cols => 'PIN',
                    sec_relevant_cols_opt => dbms_rls.ALL_ROWS);               
                    
dbms_rls.add_policy(object_schema => 'BANK_IS2',
                    object_name => 'CARD',
                    policy_name => 'card_ui_policy',
                    function_schema => 'BANK_IS2',
                    policy_function => 'account_no_policy',
                    statement_types => 'UPDATE,INSERT',
                    policy_type => dbms_rls.SHARED_STATIC);      

-- Nedovolime odstranit
dbms_rls.add_policy(object_schema => 'BANK_IS2',
                    object_name => 'CARD',
                    policy_name => 'card_d_policy',
                    function_schema => 'BANK_IS2',
                    policy_function => 'not_allowed_policy',
                    statement_types => 'DELETE',
                    policy_type => dbms_rls.SHARED_STATIC);                    

-- Vkladat zaznamy moze len zamestnanec
dbms_rls.add_policy(object_schema => 'BANK_IS2',
                    object_name => 'card',
                    policy_name => 'card_i_policy',
                    function_schema => 'BANK_IS2',
                    policy_function => 'must_be_teller_policy',
                    statement_types => 'INSERT',
                    policy_type => dbms_rls.SHARED_STATIC,
                    update_check => TRUE);            

-- Modifikovat moze len zamestnanec
dbms_rls.add_policy(object_schema => 'BANK_IS2',
                    object_name => 'card',
                    policy_name => 'card_u_policy',
                    function_schema => 'BANK_IS2',
                    policy_function => 'must_be_teller_policy',
                    statement_types => 'UPDATE',
                    policy_type => dbms_rls.SHARED_STATIC,
                    update_check => TRUE);            
end;
/

GRANT SELECT ON v_card TO client2;
GRANT SELECT ON v_card TO teller2;
GRANT INSERT ON v_card TO teller2;
GRANT UPDATE(VALID,ATM_LIMIT,PAY_LIMIT) ON v_card TO teller2;
